
//<HEADER_BEGIN>
//================================================
//File name: crxf_xls.h
//Date : January, 15 2002  12:15
//Copyright (c) 2002 - Crystal Decisions Corp.
//================================================
//<HEADER_END>

#ifndef __CRXF_XLS_H__
#define __CRXF_XLS_H__

// Section types: 
#define PE_SECT_PAGE_HEADER      2
#define PE_SECT_PAGE_FOOTER      7
#define PE_SECT_REPORT_HEADER    1
#define PE_SECT_REPORT_FOOTER    8
#define PE_SECT_GROUP_HEADER     3
#define PE_SECT_GROUP_FOOTER     5
#define PE_SECT_DETAIL           4

//The following is a special value, that indicates to use the whole report.
#define PE_SECT_WHOLE_REPORT     255

// Set 1-byte structure alignment
#if !defined(PLAT_GENERIC_UNIX) && !defined (MAINWIN) && !defined (CRPE_UNIX)
#if defined (__BORLANDC__)      // Borland C/C++
  #pragma option -a-
#elif defined (_MSC_VER)        // Microsoft Visual C++
  #if _MSC_VER >= 900           // MSVC 2.x and later
    #pragma pack (push)
  #endif
  #pragma pack (1)
#endif
#endif

#if defined (__cplusplus)
extern "C"
{
#endif

//If using the UXFXlsOptions from CR(ver 8), then the default constant column width
//MUST BE EXPRESSED IN TERMS OF CHARACTERS.
#define DEFAULT_COLUMN_WIDTH            9 //in characters.

#define DEFAULT_COLUMN_WIDTH_IN_TWIPS   720
#define MIN_CONST_COL_WIDTH_IN_TWIPS    200  //minimum 200 twips = 10 points of column width.
#define MAX_CONST_COL_WIDTH_IN_TWIPS    5760 //maximum 5760 twips = 288pts = 4"

#define UXFXls2Type    0  // These export format types are mapped to the newer ones in 
#define UXFXls3Type    1  // CR(ver 9) onwards. These definitions are retained for 
#define UXFXls4Type    2  // backward compatibility with the previous 
#define UXFXls5Type    3  // versions. Clients using these types should 
#define UXFXls5TypeExt 4  // switch over to the newer formats as defined below.
#define UXFXls5TypeTab 4  // 
#define UXFXl7Type     5  //
#define UXFXl7TabType  6  //
#define UXFXl8Type     7  //
#define UXFXl8TabType  8  //
//IMPORTANT: The above types are retained for backward compatibility. All the new 
//clients must use the format types defined below, and fill in the new version of 
//UXFXlsOptions(CR(ver 9)) structure.

//Here is a list of mappings to new formats.
//UXFXls2Type    -->  UXFXl97Type
//UXFXls3Type    -->  UXFXl97Type
//UXFXls4Type    -->  UXFXl97Type
//UXFXls5Type    -->  UXFXl97Type
//UXFXls5TypeExt -->  UXFXlRecDumpType
//UXFXls5TypeTab -->  UXFXlRecDumpType
//UXFXl7Type     -->  UXFXl97Type
//UXFXl7TabType  -->  UXFXlRecDumpType
//UXFXl8Type     -->  UXFXl97Type
//UXFXl8TabType  -->  UXFXlRecDumpType


#define UXFXl97Type         9   //This is newly added for CR(ver 9). EPF based export.
                                //This format is also called page based format.
#define UXFXlRecDumpType    10  //Just a plain record dump. Record based export. 
                                //This format is also called as "Excel(Data Only)" format.



typedef struct UXFXlsOptions
{ 
    WORD structSize;
    BOOL bColumnHeadings;   //In the CR(ver 9) export DLL, this flag is
                            //ignored.

    BOOL bUseConstColWidth; //TRUE -- use constant column width
                            //FALSE -- set column width based on an area
                            //The default value is FALSE.

    double fConstColWidth;  //the value in this field is in twips and is used only 
                            //when bUseConstColWidth is TRUE.
                            //The default value is DEFAULT_COLUMN_WIDTH_IN_TWIPS.
                            //(MIN_CONST_COL_WIDTH_IN_TWIPS <= fConstColWidth <= MAX_CONST_COL_WIDTH_IN_TWIPS)

    BOOL bTabularFormat;    //Ignored by the CR(ver 9) export DLL.

    WORD baseAreaType;      //One of the 7 Section types defined above.
                            //The default value is PE_SECT_WHOLE_REPORT.

    WORD baseAreaGroupNum;  //If baseAreaType is either GroupHeader or
                            //GroupFooter and there are more than one groups, 
                            //we need to give the group number. 
                            //The default value is 1. 

    BOOL bUseWorksheetFunc; //If TRUE, use Excel worksheet functions to represent
                            //subtotal fields in crw.
                            //only Data Only format uses this option
                            //and default value is FALSE.

#if defined (MAINWIN) || defined (PLAT_GENERIC_UNIX) || defined (CRPE_UNIX)
    DWORD dwPadding1; //padding for Solaris and other Unix platforms.
#endif

    BOOL bExportPageBreaks; //This flag indicates whether to create a page break for each page.
                            //A page break is created in the Excel worksheet for each page in the report
                            //Default value is TRUE.

    BOOL bCnvrtDateValToStr;//This flag indicates whether to convert date values to strings. When 
                            //this is TRUE, all the date & date/time fields are NOT exported as numeric
                            //values with a date format. Instead a formatted string value is exported.
                            //When this is FALSE, date & date/time fields are numeric. This flag is 
                            //introduced to work around the fact that Excel doesn't recognise dates
                            //before Jan 1, 1900. When such dates are exported, a negative number shows
                            //up in the file. However, this is useful, if you are reporting off from 
                            //exported Excel file. 
                            //Default value is FALSE.

    BOOL bExportAllPages;   //When this flag is set to TRUE, all the pages in the report are exported.
                            //If this flag is set to TRUE, the dwStartPageNumber32 and
                            //dwEndPageNumber32 are ignored.
                            //This flag is applicable only to page based export. Record based export 
                            //ignores this flag.
                            //Default value is TRUE.
    WORD wReserved1;  
    
    WORD wReserved2;    

    BOOL bExportPageHeaders;//TRUE - page header and footer area are exported.
                            //FALSE - page header and footer are not exported.
                            //default is TRUE.

#if defined (MAINWIN) || defined (PLAT_GENERIC_UNIX) || defined (CRPE_UNIX)
    DWORD dwPadding2;
#endif

    DWORD dwStartPageNumber32; //first page to be exported(1-based number). If this is > the
                               //total number of pages in the report, none of the pages are exported.
    DWORD dwEndPageNumber32;//last page to be exported(1-based number). If this is > the number
                            //of pages in the report all the pages from the dwStartPageNumber32 and onwards,
                            //are exported.

    BOOL  bChopPageHeader; //if set to TRUE this exports the bottom most line of objects in the page header area.
                            //Otherwise, all objects in page header are exported. This is used in Data Only export only.
                            //default is TRUE.

#if defined (__cplusplus)
public:
    UXFXlsOptions()
        :structSize(sizeof(UXFXlsOptions))
        ,bColumnHeadings(TRUE)
        ,bUseConstColWidth(FALSE)
        ,fConstColWidth(DEFAULT_COLUMN_WIDTH_IN_TWIPS)
        ,bTabularFormat(FALSE)
        ,baseAreaType(PE_SECT_WHOLE_REPORT)
        ,baseAreaGroupNum(1)
        ,bUseWorksheetFunc(FALSE)
        ,bExportPageBreaks(FALSE)
        ,bCnvrtDateValToStr(FALSE)
        ,bExportAllPages(TRUE)
        ,wReserved1(0)
        ,wReserved2(0)
        ,bExportPageHeaders(TRUE)
        ,dwStartPageNumber32(0)
        ,dwEndPageNumber32(0)
        ,bChopPageHeader(TRUE)
    {
    };

    ~UXFXlsOptions()
    {
    }
#endif
}
    UXFXlsOptions;

#define UXFXlsOptionsSize (sizeof (UXFXlsOptions))


#if defined (__cplusplus)
}
#endif

// Reset structure alignment
#if !defined(PLAT_GENERIC_UNIX) && !defined (MAINWIN) && !defined (CRPE_UNIX)
#if defined (__BORLANDC__)
  #pragma option -a.
#elif defined (_MSC_VER)
  #if _MSC_VER >= 900
    #pragma pack (pop)
  #else
    #pragma pack ()
  #endif
#endif
#endif


#endif 
